<?php

/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              https://www.nshift.com/
 * @since             1.0.0
 * @package           Wp_Cnsg
 *
 * @wordpress-plugin
 * Plugin Name:       nShift
 * Plugin URI:        https://www.nshift.com/
 * Description:       nShift connects your warehouse to your customers
 * Version:           1.0.0.76
 * Author:            nShift
 * Author URI:        https://www.nshift.com/
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       wp-cnsg
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Currently plugin version.
 * Start at version 1.0.0 and use SemVer - https://semver.org
 * Rename this for your plugin and update it as you release new versions.
 */
define( 'PLUGIN_NAME_VERSION_WP_CNSG', '1.0.0.76' );

/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-wp-cnsg-activator.php
 */
function activate_wp_cnsg() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-wp-cnsg-activator.php';
	$activator = new Wp_Cnsg_Activator();
    $activator->activate();
}

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-wp-cnsg-deactivator.php
 */
function deactivate_wp_cnsg() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-wp-cnsg-deactivator.php';
	Wp_Cnsg_Deactivator::deactivate();
}

register_activation_hook( __FILE__, 'activate_wp_cnsg' );
register_deactivation_hook( __FILE__, 'deactivate_wp_cnsg' );

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path( __FILE__ ) . 'includes/class-wp-cnsg.php';

/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0.0
 */
function run_wp_cnsg() {

	$plugin = new Wp_Cnsg();
	$plugin->run();

}
run_wp_cnsg();


