<?php
$included_files = get_included_files();

if(isset($_POST['action']))
{
    $page = 'settings';

    switch ($_POST['action'])
    {
        case 'update':

            $data = array( 'token'           => $_POST['token'],
                           'actor_id'        => $_POST['actor_id'],
                           'secret_key'      => $_POST['secret_key'],
                           'ticket_username' => $_POST['ticket_username'],
                           'workstation_id'  => $_POST['workstation_id'],
                           'label_type'      => $_POST['label_type'],
            );

            $response = wp_remote_post( CONSIGNOR_URL.'activate', array( 'body' => $data) );
            $response = json_decode($response['body']);
            break;
        case 'Save':
            $data = array( 'token'               => $_POST['token'],
                           'shipping_profile'    => $_POST['shipping_profile']
            );

            $response = wp_remote_post( CONSIGNOR_URL.'save-shipping-profile', array( 'body' => $data) );

            $response = json_decode($response['body']);
            $page = 'shipping-profile';
            break;
        case 'Delete':
            $data = array( 'token'               => $_POST['token'],
                           'shipping_profile'    => $_POST['shipping_profile']
            );

            $response = wp_remote_post( CONSIGNOR_URL.'delete-shipping-profile', array( 'body' => $data) );

            $response = json_decode($response['body']);
            $page = 'shipping-profile';

            break;
        case 'Refresh':
            $data = array( 'token'               => $_POST['token']
            );

            $response = wp_remote_post( CONSIGNOR_URL.'refresh-shipping-details', array( 'body' => $data) );

            $response = json_decode($response['body']);
            $page = 'shipping-profile';

            break;
        case 'Save Services':
            $data = array( 'token'               => $_POST['token'],
                           'profile_services'    => $_POST['profile_services'],
                           'services'            => true
            );

            $response = wp_remote_post( CONSIGNOR_URL.'save-shipping-services', array( 'body' => $data) );
            $response = json_decode($response['body']);

            $page = 'shipping-services';
            $response->message = array("id"=>$_POST['profile_services']['profile_id']);
            break;
        case 'Save Details':
            $data = array( 'token'   => $_POST['token'],
                'profile_details'   => $_POST['profile_details']
            );

            $response = wp_remote_post( CONSIGNOR_URL.'save-shipping-details', array( 'body' => $data) );

            $response = json_decode($response['body']);

            $page = 'shipping-details';
            $response->message = array("id"=>$_POST['profile_details']['profile_id']);
            break;
        case 'Transmit':
            if(isset($_POST['shipment']))
            {
                $data = array('token'       => $_POST['token'],
                              'shipments'   => array_keys($_POST['shipment']));
            }
            else
            {
                $data = array('token'       => $_POST['token'],
                              'shipments'   => '');
            }
            $response = wp_remote_post( CONSIGNOR_URL.'transmit-shipments', array( 'body' => $data) );

            $response = json_decode($response['body']);
            $page = 'transmit';
            break;
    }

    if($response->code == 200)
    {
        getPage_wp_cnsg($page,'',$response->message);
    }
    else
    {
        getPage_wp_cnsg($page,$response->message);
    }

}
elseif(isset($_GET))
{
    if(isset($_GET['tab']))
    {
        switch ($_GET['tab'])
        {
            case 'credentials':
                getPage_wp_cnsg('settings');
                break;
            case 'shipping_profiles':
                getPage_wp_cnsg('shipping-profile');
                break;
            case 'shipping_services':
                getPage_wp_cnsg('shipping-services','',array("id"=>$_GET['id']));
                break;
            case 'shipping_details':
                getPage_wp_cnsg('shipping-details','',array("id"=>$_GET['id']));
                break;
           case 'transmit':
                getPage_wp_cnsg('transmit');
                break;
           case 'documents':
                add_thickbox();
                getPage_wp_cnsg('documents');
                break;
            default:
                getPage_wp_cnsg('settings');
                break;
        }

    }
    else
    {
        getPage_wp_cnsg('settings');
    }

}

function getPage_wp_cnsg($page,$error = '',$action = '')
{
    global $wpdb;
    $table_name = $wpdb->prefix.'woocommerce_consignor_user';

    $token = $wpdb->get_results("SELECT token FROM " . $table_name." LIMIT 1");
    $data = array( 'token'  => $token[0]->token,  'error' => $error, 'action' => $action);
    // $response = wp_remote_post( CONSIGNOR_URL.$page, array( 'body' => $data) );

    // $response = json_decode($response['body']);

    $curl = curl_init();

    curl_setopt_array($curl, array(
      CURLOPT_URL => CONSIGNOR_URL.$page,
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => '',
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 0,
      CURLOPT_FOLLOWLOCATION => true,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => 'POST',
      CURLOPT_VERBOSE => true,
      CURLOPT_POSTFIELDS =>  http_build_query($data),
      CURLOPT_HTTPHEADER => array(
        'Content-Type: application/x-www-form-urlencoded'
      ),
    ));

    $response = curl_exec($curl);

    $response = json_decode($response);
    if($response->code == 200)
    {
        echo $response->message;
    }

}


?>


