<?php

/**
 * The file that defines the core plugin class
 *
 * A class definition that includes attributes and functions used across both the
 * public-facing side of the site and the admin area.
 *
 * @link       https://www.consignor.com/
 * @since      1.0.0
 *
 * @package    Wp_Cnsg
 * @subpackage Wp_Cnsg/includes
 */

/**
 * The core plugin class.
 *
 * This is used to define internationalization, admin-specific hooks, and
 * public-facing site hooks.
 *
 * Also maintains the unique identifier of this plugin as well as the current
 * version of the plugin.
 *
 * @since      1.0.0
 * @package    Wp_Cnsg
 * @subpackage Wp_Cnsg/includes
 * @author     Consignor <integrations@consignor.com>
 */
class Wp_Cnsg {

	/**
	 * The loader that's responsible for maintaining and registering all hooks that power
	 * the plugin.
	 *
	 * @since    1.0.0
	 * @access   protected
	 * @var      Wp_Cnsg_Loader    $loader    Maintains and registers all hooks for the plugin.
	 */
	protected $loader;

	/**
	 * The unique identifier of this plugin.
	 *
	 * @since    1.0.0
	 * @access   protected
	 * @var      string    $plugin_name    The string used to uniquely identify this plugin.
	 */
	protected $plugin_name;

	/**
	 * The current version of the plugin.
	 *
	 * @since    1.0.0
	 * @access   protected
	 * @var      string    $version    The current version of the plugin.
	 */
	protected $version;

	/**
	 * Define the core functionality of the plugin.
	 *
	 * Set the plugin name and the plugin version that can be used throughout the plugin.
	 * Load the dependencies, define the locale, and set the hooks for the admin area and
	 * the public-facing side of the site.
	 *
	 * @since    1.0.0
	 */
	public function __construct() {
		if ( defined( 'PLUGIN_NAME_VERSION_WP_CNSG' ) ) {
			$this->version = PLUGIN_NAME_VERSION_WP_CNSG;
		} else {
			$this->version = '1.0.0';
		}
		$this->plugin_name = 'wp-cnsg';

		$this->load_dependencies();
		$this->set_locale();
		$this->define_admin_hooks();
		$this->define_public_hooks();

	}

	/**
	 * Load the required dependencies for this plugin.
	 *
	 * Include the following files that make up the plugin:
	 *
	 * - Wp_Cnsg_Loader. Orchestrates the hooks of the plugin.
	 * - Wp_Cnsg_i18n. Defines internationalization functionality.
	 * - Wp_Cnsg_Admin. Defines all hooks for the admin area.
	 * - Wp_Cnsg_Public. Defines all hooks for the public side of the site.
	 *
	 * Create an instance of the loader which will be used to register the hooks
	 * with WordPress.
	 *
	 * @since    1.0.0
	 * @access   private
	 */
	private function load_dependencies() {

		/**
		 * The class responsible for orchestrating the actions and filters of the
		 * core plugin.
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/class-wp-cnsg-loader.php';

		/**
		 * The class responsible for defining internationalization functionality
		 * of the plugin.
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/class-wp-cnsg-i18n.php';

		/**
		 * The class responsible for defining all actions that occur in the admin area.
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'admin/class-wp-cnsg-admin.php';

		/**
		 * The class responsible for defining all actions that occur in the public-facing
		 * side of the site.
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'public/class-wp-cnsg-public.php';

		/**
		 * The class responsible for shipping methods
		 */
		// require_once plugin_dir_path( dirname( __FILE__ ) ) . 'public/wp_cnsg_shipping_method.php';


		$this->loader = new Wp_Cnsg_Loader();

	}

	/**
	 * Define the locale for this plugin for internationalization.
	 *
	 * Uses the Wp_Cnsg_i18n class in order to set the domain and to register the hook
	 * with WordPress.
	 *
	 * @since    1.0.0
	 * @access   private
	 */
	private function set_locale() {

		$plugin_i18n = new Wp_Cnsg_i18n();

		$this->loader->add_action( 'plugins_loaded', $plugin_i18n, 'load_plugin_textdomain' );

	}

	/**
	 * Register all of the hooks related to the admin area functionality
	 * of the plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 */
	private function define_admin_hooks() {

		$plugin_admin = new Wp_Cnsg_Admin( $this->get_plugin_name(), $this->get_version() );

		$this->loader->add_action( 'admin_enqueue_scripts', $plugin_admin, 'enqueue_styles' );
        $this->loader->add_action( 'admin_enqueue_scripts', $plugin_admin, 'enqueue_scripts' );

        $this->loader->add_action( 'admin_menu', $plugin_admin, 'menu_button' );

        $this->loader->add_action('add_meta_boxes', $plugin_admin,'cnsg_add_label_metabox');

        $this->loader->add_action( 'save_post', $plugin_admin,'mv_save_wc_order_other_fields', 10, 1 );
    }

	/**
	 * Register all of the hooks related to the public-facing functionality
	 * of the plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 */
	private function define_public_hooks() {

		$plugin_public = new Wp_Cnsg_Public( $this->get_plugin_name(), $this->get_version() );

		$this->loader->add_action( 'wp_enqueue_scripts', $plugin_public, 'enqueue_styles' );
		$this->loader->add_action( 'wp_enqueue_scripts', $plugin_public, 'enqueue_scripts' );
		
		/**
		 * Add the field to the checkout
		 */
		// $this->loader->add_action( 'woocommerce_after_order_notes', $plugin_public,'my_custom_checkout_field' );

	// $this->loader->add_filter( 'woocommerce_shipping_methods', $plugin_public,'add_cnsg_shipping_method' );
	}

	/**
	 * Run the loader to execute all of the hooks with WordPress.
	 *
	 * @since    1.0.0
	 */
	public function run() {
		$this->loader->run();
	}

	/**
	 * The name of the plugin used to uniquely identify it within the context of
	 * WordPress and to define internationalization functionality.
	 *
	 * @since     1.0.0
	 * @return    string    The name of the plugin.
	 */
	public function get_plugin_name() {
		return $this->plugin_name;
	}

	/**
	 * The reference to the class that orchestrates the hooks with the plugin.
	 *
	 * @since     1.0.0
	 * @return    Wp_Cnsg_Loader    Orchestrates the hooks of the plugin.
	 */
	public function get_loader() {
		return $this->loader;
	}

	/**
	 * Retrieve the version number of the plugin.
	 *
	 * @since     1.0.0
	 * @return    string    The version number of the plugin.
	 */
	public function get_version() {
		return $this->version;
	}

}

function cnsg_ship_order_popup()
{
    global $wpdb;

    $order = new WC_Order($_GET['post']); // Order id

    $shipping_address = $order->get_address('shipping');
    $billing_address  = $order->get_address('billing');
    $order_date       = $order->get_date_created();
    $comment          = $order->get_customer_note();
    $items            = array();
    $amount           = floatval( preg_replace( '#[^\d.]#', '', $order->get_total() ) );
    $currency         = get_woocommerce_currency();
	$mailer 		  = WC()->mailer();
	$from_email 	  = $mailer->get_from_address();
	$attributes       = array();
	$total_quantity         = 0;

    foreach( $order->get_items() as $item_id => $product_item )
    {

        $quantity       = $product_item->get_quantity(); // get quantity
        $product        = $product_item->get_product(); // get the WC_Product object
        if( $product )
        {     	
	        $product_weight = $product->get_weight(); // get the product weight
	        $product_height = $product->get_height(); // get the product height
	        $product_length = $product->get_length(); // get the product length
	        $product_width  = $product->get_width(); // get the product width
	        $product_name   = $product->get_name();

	        $items[] = array('quantity' => $quantity,
	                         'weight'   => $product_weight,
	                         'height'   => $product_height,
	                         'length'   => $product_length,
	                         'width'    => $product_width,
	                         'name'     => $product_name);

			$item_attribute  = $product->get_attributes();

			$total_quantity  += $quantity;

			foreach ($item_attribute as  $item_attribute_value) 
			{
			    if(!empty($item_attribute_value->get_name()) && !empty($item_attribute_value->get_options())) 
			    {
	                $attributes[$item_attribute_value->get_name()] = $item_attribute_value->get_options()[0];
	            }
			}
        }
    }

    $order = array('billing_address'  => $billing_address,
                   'shipping_address' => $shipping_address,
                   'order_date'       => $order_date,
                   'items'            => $items,
                   'order_id'         => $_GET['post'],
                   'order_note'       => $comment,
               	   'quantity'         => $total_quantity,
               	   'attributes'       => $attributes);

    $table_name = $wpdb->prefix.'woocommerce_consignor_user';

    $token = $wpdb->get_results("SELECT token FROM " . $table_name." LIMIT 1");

    $data = array( 'token'         => $token[0]->token,
                   'order'         => $order,
                   'currency'      => $currency,
                   'total'         => $amount,
                   'sender_email'  => $from_email,
                   'version'       => PLUGIN_NAME_VERSION_WP_CNSG);
    $curl = curl_init();


    curl_setopt_array($curl, array(
      CURLOPT_URL => CONSIGNOR_URL.'shipment-order',
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => '',
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 0,
      CURLOPT_FOLLOWLOCATION => true,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => 'POST',
      CURLOPT_VERBOSE => true,
      CURLOPT_POSTFIELDS =>   http_build_query($data),
      CURLOPT_HTTPHEADER => array(
        'Content-Type: application/x-www-form-urlencoded'
      ),
    ));

    $response = curl_exec($curl);

    $response = json_decode($response);
    // $response = wp_remote_post( CONSIGNOR_URL.'shipment-order', array( 'body' => $data) );

    // $response = json_decode($response['body']);

    if($response->code == 200)
    {
        add_thickbox();

        echo $response->message;
    }



}

