<?php

/**
 * Fired during plugin activation
 *
 * @link       https://www.consignor.com/
 * @since      1.0.0
 *
 * @package    Wp_Cnsg
 * @subpackage Wp_Cnsg/includes
 */

/**
 * Fired during plugin activation.
 *
 * This class defines all code necessary to run during the plugin's activation.
 *
 * @since      1.0.0
 * @package    Wp_Cnsg
 * @subpackage Wp_Cnsg/includes
 * @author     Consignor <integrations@consignor.com>
 */

class Wp_Cnsg_Activator
{

	/**
	 * Short Description. (use period)
	 *
	 * Long Description.
	 *
	 * @since    1.0.0
	 */
	public function activate()
    {
        $this->checkDependency();
        $this->register();
	}

    /**
     * Checks if the WooCommerce plugin is activated
     *
     * If the WooCommerce plugin is not active, then don't allow the
     * activation of this plugin.
     *
     * @since 1.0.0
     */
	private function checkDependency()
    {
        if ( ! function_exists( 'is_plugin_active_for_network' ) )
        {
            include_once( ABSPATH . '/wp-admin/includes/plugin.php' );
        }

        if ( ! current_user_can( 'activate_plugins' ) )
        {
            // Deactivate the plugin.
            deactivate_plugins( plugin_basename( __FILE__ ) );

            $error_message = __( 'You do not have proper authorization to activate a plugin!', 'wp-cnsg' );
            die( esc_html( $error_message ) );
        }

        if ( ! class_exists( 'WooCommerce' ) )
        {
            // Deactivate the plugin.
            deactivate_plugins( plugin_basename( __FILE__ ) );
            // Throw an error in the WordPress admin console.
            $error_message = __( 'This plugin requires ', 'wp-cnsg' ) . '<a href="' . esc_url( 'https://wordpress.org/plugins/woocommerce/' ) . '">WooCommerce</a>' . __( ' plugin to be active!', 'wp-cnsg' );
            die( wp_kses_post( $error_message ) );
        }
    }

    /**
     * Register plugin and generate token
     *
     * @since 1.0.0
     */
    private function register()
    {
        global $wpdb;
        $table_name = $wpdb->prefix.'woocommerce_consignor_user';
        $query = $wpdb->prepare( "SHOW TABLES LIKE %s", $wpdb->esc_like( $table_name ) );

        if ( ! function_exists( 'is_plugin_active_for_network' ) )
        {
            include_once( ABSPATH . '/wp-admin/includes/plugin.php' );
        }

        if ( $wpdb->get_var( $query ) == $table_name )
        {
              //check if token is present
            global $wpdb;
            $wpdb->get_results("SELECT token FROM " . $table_name);

            if($wpdb->num_rows != 1)
            {
                $wpdb->get_results("TRUNCATE ".$table_name);
                $this->insertToken($table_name);
            }
        }
        else
        {
            // create table
            $sql = "CREATE TABLE IF NOT EXISTS 	".$table_name." ( ".
                   "user_id INT AUTO_INCREMENT, ".
                   "token VARCHAR(255) NOT NULL, ".
                   "PRIMARY KEY (user_id) ) ENGINE=INNODB; ";

            $wpdb->query($sql);
            //check if the table was created
            if ( $wpdb->get_var( $query ) == $table_name )
            {
                $this->insertToken($table_name);
            }
            else
            {
                // Deactivate the plugin.
                deactivate_plugins( plugin_basename( __FILE__ ) );
                // Throw an error in the WordPress admin console.
                $error_message = __( 'Plugin installation failed, please try again!', 'wp-cnsg' );
                die( wp_kses_post( $error_message ) );
            }
        }

    }

    private function insertToken($table_name)
    {
        global $wpdb;

        //get info
        global $woocommerce;

        $wp_version   = get_bloginfo('version');
        $woo_version  = $woocommerce->version;
        $site_url     = get_bloginfo('wpurl');
        $email        = get_bloginfo('admin_email');

        //send request
        $data = array( 'wp_version' => $wp_version, 'woo_version' => $woo_version, 'site_url' => $site_url, 'email' => $email);
        // $response = wp_remote_post( CONSIGNOR_URL.'integrate', array( 'body' => $data) );

        // //check error
        // $decodedResponse = json_decode($response['body']);
        $curl = curl_init();

        curl_setopt_array($curl, array(
          CURLOPT_URL => CONSIGNOR_URL.'integrate',
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => '',
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 0,
          CURLOPT_FOLLOWLOCATION => true,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => 'POST',
          CURLOPT_VERBOSE => true,
          CURLOPT_POSTFIELDS =>  http_build_query($data),
          CURLOPT_HTTPHEADER => array(
            'Content-Type: application/x-www-form-urlencoded'
          ),
        ));

        $response = curl_exec($curl);

        //check error
        $decodedResponse = json_decode($response);
        switch ($decodedResponse->code)
        {
            case '404':
                // Deactivate the plugin.
                deactivate_plugins( plugin_basename( __FILE__ ) );
                // Throw an error in the WordPress admin console.
                $error_message = __( 'Plugin installation failed, please contact Consignor Customer service. '.
                        'You can find contact details to your local customer service department at consignor.com. !', 'wp-cnsg' ).
                    '<a href="' . esc_url( 'https://www.nshift.com/' ) . '">nShift.com.</a>'. __( ' !', 'wp-cnsg' );
                die( wp_kses_post( $error_message ) ); //TODo
                break;
            case '200':
                $wpdb->insert($table_name, array('token' => $decodedResponse->token) );
                break;
        }
    }

}
