(function( $ ) {
	'use strict';
	var CONSIGNOR_URL = 'https://integration.consignor.com/woocommerce/';
	/**
	 * All of the code for your admin-facing JavaScript source
	 * should reside in this file.
	 *
	 * Note: It has been assumed you will write jQuery code here, so the
	 * $ function reference has been prepared for usage within the scope
	 * of this function.
	 *
	 * This enables you to define handlers, for when the DOM is ready:
	 *
	 * $(function() {
	 *
	 * });
	 *
	 * When the window is loaded:
	 *
	 * $( window ).load(function() {
	 *
	 * });
	 *
	 * ...and/or other possibilities.
	 *
	 * Ideally, it is not considered best practise to attach more than a
	 * single DOM-ready or window-load handler for a particular page.
	 * Although scripts in the WordPress core, Plugins and Themes may be
	 * practising this, we should strive to set a better example in our own work.
	 */
	// this is the id of the form
    $(document).ready(function() {

      jQuery("#submitShip").click(function(e) {

			var form = getAllValues();

      var url  = CONSIGNOR_URL+'submit-shipment';

			$.ajax({
			    type: "POST",
			    url: url,
			    data: {'data' : form}, // serializes the form's elements.
			    success: function(data)
			    {
			    	data = JSON.parse(data);

                    var popup = document.getElementById('cnsg-submit-popup');
					if(data.hasOwnProperty("error"))
					{
                        if (document.contains(document.getElementById("submit-shipment-error")))
                        {
                            document.getElementById("submit-shipment-error").remove();
                        }
                        var form_div = document.getElementById('cnsg-submit-popup-body');
                        var div      = document.createElement('div');
                        div.className = 'notice notice-error is-dismissible';
                        div.setAttribute("id", "submit-shipment-error");

                        for (var key in data.error)
                        {
                        	if(key != 0)
							              {
                                div.innerHTML = '<p>'+data.error[key]+'</p>';
                            }
                        }

                        form_div.parentNode.insertBefore(div, form_div);
                        popup.scrollTop = 0;
					}
					else
					{
                        location.reload();
					}


                }
			});

			e.preventDefault(); // avoid to execute the actual submit of the form.
		});

        $('#shipping-profile').change(function() {

            var url  		 = CONSIGNOR_URL+'get-shipping-profile-details';
		  	    var token 		 = document.getElementById("token").value;
            var id = $(this).val() ;
            // document.getElementById("shipment-button").classList.remove('button');
            var name1       = document.getElementById("receiver_name1").value;
            var street1     = document.getElementById("receiver_address1").value;
            var postcode    = document.getElementById("receiver_zip").value;
            var city        = document.getElementById("receiver_city").value;
            var countrycode = document.getElementById("receiver_country").value;


            var address = { 'name1'       : name1,
                            'street1'     : street1,
                            'postcode'    : postcode,
                            'city'        : city,
                            'countrycode' : countrycode }; 
            if( id == "--" )
            {
                document.getElementById('submitShip').setAttribute('disabled','disabled');
                document.getElementById('submitShip').setAttribute('class','btn btn-warning');
            }
            else
            {
                document.getElementById('submitShip').removeAttribute('disabled');
                document.getElementById('submitShip').setAttribute('class','btn btn-success');

            }
			var send_data = {'token':token , 'id' : id, 'address': address};
            $.ajax({
                type: "POST",
                url: url,
                data: {'data' : send_data}, // serializes the form's elements.
                success: function(data)
                {
                    data = JSON.parse(data);
                 
                    if( (data.message.droppoints != false || data.message.shipping_profile != false) && 
                         data.code == '200')
					           {
                        if(data.message.shipping_profile != false)
                        {
                            if( (jQuery)("#DropPointRemove").length )
                            {
                                (jQuery)("#DropPointRemove").remove();
                            }
                            (jQuery)('.goods-type').find('option').remove().end();
                            (jQuery)('.goods-type').append($('<option>', {
                                value: '--',
                                text: '--'
                            }));
                            for (var key in data.message.shipping_profile)
                            {
                                (jQuery)('.goods-type').append($('<option>', {
                                    value: data.message.shipping_profile[key].key,
                                    text: data.message.shipping_profile[key].label
                                }));
                            }
                        }

                        if(data.message.droppoints != false)
                        {
                            var html =  '<div class="form-group" id="DropPointRemove">'+
                                        '<label for="droppoints">Drop Points</label>'+
                                        '<select class="shipping-profile form-control" id="droppoints" name="droppoints">'+
                                        '<option value="--" >--</option>';
                            for (var key in data.message.droppoints)
                            {
                                html += "<option value='"+key+"' >"+data.message.droppoints[key]+"</option>";
                            }            
                            html += '</select></div>';
                            if( (jQuery)("#DropPointRemove").length )
                            {
                                (jQuery)("#DropPointRemove").remove();
                            }
                            var insert_element     = document.getElementById("DropPointInsert");
                            (jQuery)(html).insertAfter(insert_element);
                        }
                        
                    }
                    else
                    {
                        console.log('no droppoints');
                        if( (jQuery)("#DropPointRemove").length )
                        {
                            (jQuery)("#DropPointRemove").remove();
                        }

                        (jQuery)('.goods-type').find('option').remove().end();
                        (jQuery)('.goods-type').append($('<option>', {
                            value: '--',
                            text: '--'
                        }));
                    }
                }
            });
        });

        var select = $('.goods-type');
        select.change(function () {
            select.not(this).val(this.value);
        });

        $("#shipping-profile").change(function(){
           var defaultAddress = $('option:selected', this).attr("defaultAddress");
            if(defaultAddress == 0)
            {
                jQuery('#nextSenderAddress').attr("href","#collapseSenderAddress");
                jQuery('#nextSenderAddress').attr("aria-controls","#collapseSenderAddress");
            }

            if(defaultAddress == 1)
            {
               jQuery('#nextSenderAddress').attr("href","#collapseReceiverAddress");
               jQuery('#nextSenderAddress').attr("aria-controls","#collapseReceiverAddress");
            }

        });
        jQuery('#nextReceiverAddress').click(function(){
                  var a = jQuery('[href="#collapseReceiverAddress"]').get(); 
                  a[1].removeAttribute('disabled');
                });
        jQuery('#nextShippingProfile').click(function(){
                  var a = jQuery('[href="#collapseGoodsLine"]').get(); 
                  a[1].removeAttribute('disabled');
                });
        jQuery('#nextSenderAddress').click(function(){
                  //get default address
                  var defaultAddress = jQuery('#shipping-profile').find('option:selected').attr('defaultAddress');
                  //check if value is selected
                  if(defaultAddress == 0)
                  {
                      var a = jQuery('[href="#collapseSenderAddress"]').get(); 
                      a[1].removeAttribute('disabled');
                  }

                  if(defaultAddress == 1)
                  {
                      var a = jQuery('[ext="collapseReceiverAddress"]').get(); 
                      a[0].removeAttribute('disabled');
                  }
             

                });
           jQuery('#nextArticleInfo').click(function(){
                  //check if value is selected
                  var a = jQuery('[href="#collapseArticleInfo"]').get(); 
                  a[1].removeAttribute('disabled');

                });
           jQuery('#article-and-label').click(function(){
                  //check if value is selected
                  generateDetailsAndArticleInformation();

                });

  });

    $(document).ready(function() {

        jQuery("#deleteShip").click(function(e) {

            var url          = CONSIGNOR_URL+'delete-shipment';
            var data         = {};
            data['token']    = document.getElementById("deleteShip").getAttribute("token");
            data['order_id'] = document.getElementById("deleteShip").getAttribute("order");

            $.ajax({
                type: "POST",
                url: url,
                data: {'data' : data}, // serializes the form's elements.
                success: function(data)
                {
                    data = JSON.parse(data);

                    if(data.hasOwnProperty("error")) {
                        $("html, body").animate({scrollTop: 0}, "slow");
                        (jQuery)('<div class="notice notice-error is-dismissible"><p>' + data.error + '</p>').insertBefore(document.getElementById("poststuff"));
                    }
                    else {
                        location.reload();
                    }
                }
            });
        });
            // e.preventDefault(); // avoid to execute the actual submit of the form.

            jQuery('.transmit-menu a').click(function(){
                 var old_element = document.querySelector('.transmit-menu-active');
                 var old_table_element_class = '.'+old_element+'-table';
                 old_element.classList.remove('transmit-menu-active');
                 document.querySelector('.'+old_element.id+'-table').classList.add('transmit-table-hide');
                 var  new_element = document.getElementById(this.id);
                 new_element.classList.add('transmit-menu-active');
                 document.querySelector('.'+new_element.id+'-table').classList.remove('transmit-table-hide');
              });

        });
    jQuery('#shipment-button').click(function() {
        console.log('button');
        var TB_WIDTH = 100,
            TB_HEIGHT = 100; // set the new width and height dimensions here..
        $("#TB_ajaxContent").animate({
            marginLeft: '-' + parseInt((TB_WIDTH / 2), 10) + 'px',
            width: TB_WIDTH + 'px',
            height: TB_HEIGHT + 'px',
            marginTop: '-' + parseInt((TB_HEIGHT / 2), 10) + 'px'
        });
    });

})( jQuery );


function getAllValues() {
    var allVal = {};

    jQuery("#submit-shipment-form").find(':input').each(function () {
        var key = jQuery(this).attr('name');

        if(key === undefined)
        {
            return;
        }

        var line_match = key.match(/line\[(\d)\]\[(.*?)\]/);
        var item_match = key.match(/items\[(\d)\]\[(.*?)\]/);
        var article_match = key.match(/article\[(\d)\]\[(.*?)\]/);
        var custom_match = key.match(/custom\[(\d)\]\[(.*?)\]/);
        if(line_match !== null)
        {
            line_match = Object.values(line_match);
            var line_number = line_match[1];
            var line_field  = line_match[2];
            if(allVal['line'] === undefined)
            {
                allVal['line']= { [line_number]: {[line_field] : jQuery(this).val()} };
            }
            else if(!(line_number in allVal['line']) )
            {
                allVal['line'][line_number] = {[line_field] : jQuery(this).val()} ;
            }
            else
            {
                allVal['line'][line_number][line_field] = jQuery(this).val();
            }

        }
        else if(item_match !== null)
        {
            item_match = Object.values(item_match);
            var line_number = item_match[1];
            var line_field = item_match[2];
            if(allVal['items'] === undefined)
            {
                allVal['items']= { [line_number]: {[line_field] : jQuery(this).val()} };
            }
            else if(!(line_number in allVal['items']) )
            {
                allVal['items'][line_number] = {[line_field] : jQuery(this).val()} ;
            }
            else
            {
                allVal['items'][line_number][line_field] = jQuery(this).val();
            }
        }
        else if(article_match !== null)
        {
            article_match = Object.values(article_match);
            var line_number = article_match[1];
            var line_field = article_match[2];
            if(allVal['article'] === undefined)
            {
                allVal['article']= { [line_number]: {[line_field] : jQuery(this).val()} };
            }
            else if(!(line_number in allVal['article']) )
            {
                allVal['article'][line_number] = {[line_field] : jQuery(this).val()} ;
            }
            else
            {
                allVal['article'][line_number][line_field] = jQuery(this).val();
            }
        }
        else if(custom_match !== null)
        {
            custom_match = Object.values(custom_match);
            var line_number = custom_match[1];
            var line_field = custom_match[2];
            if(allVal['custom'] === undefined)
            {
                allVal['custom']= { [line_number]: {[line_field] : jQuery(this).val()} };
            }
            else if(!(line_number in allVal['custom']) )
            {
                allVal['custom'][line_number] = {[line_field] : jQuery(this).val()} ;
            }
            else
            {
                allVal['custom'][line_number][line_field] = jQuery(this).val();
            }
        }
        else
        {
            allVal[key] = jQuery(this).val();
        }
    });

    return allVal;

}

Element.prototype.appendAfter = function (element) {
    element.parentNode.insertBefore(this, element.nextSibling);
}, false;

function addNewLine(line_prefix,big_div_id,menu_id,active_class,input_identifier,hide_class)
{
   //Constant name definition
   var line_prefix      = line_prefix;
   var big_div_id       = big_div_id;
   var menu_id          = menu_id;
   var active_class     = active_class;
   var input_identifier = input_identifier;
   var hide_class       = hide_class;
   //Get last line
   var last_line_class  = document.getElementById(big_div_id).lastChild.previousElementSibling.className;
   //check if div is hidden 
   if(last_line_class.indexOf(hide_class) !== -1)
   {
       var last_line_class = last_line_class.replace(hide_class, "");
   }
   //Get last line number
   var last_line_number = last_line_class.replace(line_prefix+'-', "");
   // get last line id
   var last_line_id     = jQuery('ul#'+menu_id).find('li.active')[0].id;
   //get last active number
   var last_active_number = last_line_id.replace(menu_id+'-', "");   
   //change active class
   var last_active_menu =  jQuery('ul#'+menu_id).find('li.active').removeClass( active_class );
   //generate menu line
   var menu_line = '<li role="presentation" class="active cnsg-cursor-pointer" id="'+menu_id+'-'+(parseInt(last_line_number)+1)+'"><a>Line '+(parseInt(last_line_number)+1)+'</a></li>'; 
   //Add new button
   document.getElementById(menu_id).innerHTML += menu_line;
   //Get last div dom element
   var form_element_string   =  jQuery('#'+big_div_id).children().last()[0].outerHTML;
   //Replace name and ids
   var previous_identifier = input_identifier+'['+last_line_number+']';
   var next_form = form_element_string.split(previous_identifier.replace(/\s/g, '')).join(input_identifier+'['+(parseInt(last_line_number)+1)+']');
   var next_form = next_form.replace(line_prefix+'-'+last_line_number, line_prefix+'-'+(parseInt(last_line_number)+1)+' ');
   if(next_form.indexOf(hide_class) !== -1)
   {
      var next_form = next_form.replace(hide_class, "");         
   }
   //Insert div in HTML
   jQuery('.'+last_line_class).after(next_form);
   //get last active div
   jQuery('.'+line_prefix+'-'+last_active_number).addClass(hide_class);
}

function changeTabOnClick(id, menu, line)
{
    var ul       = document.getElementById(id);
    var menu_id  = menu; 
    var tab_name = menu;//'goods-line-menu'; 
    var div_tab  = line;//'line';
        jQuery('#'+id+' li').live('click', function() 
        {
        // Get last active class and remove it
        var last_line_id     = jQuery('ul#'+menu_id).find('li.active')[0].id;
        var last_active_menu =  jQuery('ul#'+menu_id).find('li.active').removeClass( "active" );
        var last_line_number = last_line_id.replace(menu_id+'-', "");
        jQuery('.'+div_tab+'-'+last_line_number).addClass('transmit-table-hide');

        var new_tab = jQuery(this).attr('id');
        var new_tab_number = new_tab.replace(tab_name+'-', "");

        jQuery('.'+div_tab+'-'+new_tab_number).removeClass('transmit-table-hide');
        jQuery('#'+tab_name+'-'+new_tab_number).addClass('active');
      
    });
}

function changeArticleTabOnClick(param)
{
     // var ul = document.getElementById('article-menu-tabs');
        // Get last active class and remove it
        var last_active_tab     = jQuery('ul#article-menu-tabs').find('li.active')[0].id;
        switch(last_active_tab) {
                      case 'article-information':
                         var new_active_tab      = 'customs-information';
                        break;
                      case 'customs-information':
                         var new_active_tab      = 'article-information';
                        break;
                      default:
                        // code block
                    }
        // console.log(last_line_id);
        jQuery('ul#article-menu-tabs').find('li.active').removeClass( "active" );
        jQuery('#'+new_active_tab).addClass('active');
        // var last_line_number = last_line_id.replace(menu_id+'-', "");
        jQuery('#'+new_active_tab+'-tab').removeClass('transmit-table-hide');
        jQuery('#'+last_active_tab+'-tab').addClass('transmit-table-hide');

        // var new_tab = jQuery(this).attr('id');
        // var new_tab_number = new_tab.replace(tab_name+'-', "");

        // jQuery('#'+tab_name+'-'+new_tab_number).addClass('active');

}

function generateDetailsAndArticleInformation(){
// {
//     //get shipping profile from select menu
   var CONSIGNOR_URL           = 'https://integration.consignor.com/woocommerce/';
   var token                   = document.getElementById("token").value;
   var shipping_profile_value  =  jQuery( "#shipping-profile option:selected" )[0].value;
   var last_element_lines      = document.getElementById("lines").lastChild.previousElementSibling.className;
   var last_line_number        = last_element_lines.replace('line-', "");
   var quantity 	 		   = document.getElementById("quantity").value;
   var article_info            = document.getElementById("article_info").value;
   // var form = 
//     //get article and details from WS
    var url  = CONSIGNOR_URL+'get-shipping-details';
    jQuery.ajax({
        type: "POST",
        url: url,
        data: {'token'      : token,
               'action[id]' : shipping_profile_value,
               'goodsLine'  : last_line_number,
               'quantity' : quantity, 
               'article_info' : article_info}, // serializes the form's elements.

        success: function(data)
        {
            data = JSON.parse(data);
        
            var popup = document.getElementById('cnsg-submit-popup');
            if(data.hasOwnProperty("error"))
            {
                if (document.contains(document.getElementById("submit-shipment-error")))
                {
                    document.getElementById("submit-shipment-error").remove();
                }
                var form_div = document.getElementById('cnsg-submit-popup-body');
                var div      = document.createElement('div');
                div.className = 'notice notice-error is-dismissible';
                div.setAttribute("id", "submit-shipment-error");

                for (var key in data.error)
                {
                    if(key != 0)
                    {
                        div.innerHTML = '<p>'+data.error[key]+'</p>';
                    }
                }
                
                var div_article = document.getElementById("article-information-container");

                div_article.innerHTML = "";

                form_div.parentNode.insertBefore(div, form_div);
                popup.scrollTop = 0;
            }
            else
            {
                 var div = document.getElementById("article-information-container");
                 div.innerHTML = data.message;
            }


        }
    });
}

function setAllCheckboxes(id, sourceCheckbox)
{
    divElement = document.getElementById(id);
    inputElements = divElement.getElementsByTagName('input');
    jQuery("#goods-line-menu .active");
    for (i = 0; i < inputElements.length; i++)
    {
        if (inputElements[i].type != 'checkbox')
            continue;
        inputElements[i].checked = sourceCheckbox.checked;
    }
}

function addElement(elementID,html)
{
    document.getElementById(elementID).innerHTML = html;
}

function addNewGoodsline(line_number)
{
    //get all line numbers
    var line_number_list = document.getElementById("line-number");
    var line_number_options = '';
    //generate line numbers options
    for (i = 0; i < line_number_list.length; i++)
    {
        line_number_options += '<option values = "'+line_number_list.options[i].value+'">'+line_number_list.options[i].text+'</options>';
    }

    //get all line names
    var line_name_list = document.getElementById("item-name");
    var line_name_options = '';
    //generate line names options
    for (i = 0; i < line_name_list.length; i++)
    {
        line_name_options += '<option values = "'+line_name_list.options[i].value+'">'+line_name_list.options[i].text+'</options>';
    }


    var last_line_id = jQuery('#article tr:last').attr('id').match(/(\d)/g);;
    var new_line_id  = Number(last_line_id) + 1;
    var new_line = document.createElement('tr');

    new_line.innerHTML = '  <td class="article-name">\n' +
        '                            <select class="line-name" id="item-name" name="items['+new_line_id+'][name]">\n' +
        '                                 '+line_name_options +
        '                           </select>\n' +
        '                        </td>\n' +
        '                        <td class="product-quantity">\n' +
        '                            <input type="text" name="items['+new_line_id+'][quantity]" >\n' +
        '                        </td>\n' +
        '                        <td class="product-weight">\n' +
        '                            <input type="text" name="items['+new_line_id+'][weight]">\n' +
        '                        </td>\n' +
        '                       <td class="goods-line-number" id="goods-line-number-'+new_line_id+'">\n' +
        '                           <select class="item-line-number" id="line-number-'+new_line_id+'" name="items['+new_line_id+'][line-number]">\n' +
        '                            '+line_number_options +
        '                           </select>\n' +
        '                       </td>\n' +
        '                        <td id="line-action-1" class="line-action">\n' +
        '                            <button type="button" class="btn btn-circle btn-primary" onclick="addNewGoodsline('+new_line_id+')">\n' +
        '                                <i class="glyphicon glyphicon-plus"></i>\n' +
        '                            </button>\n' +
        '                            <button type="button" class="btn btn-circle btn-primary" onclick="removeNewGoodsline('+new_line_id+')">\n' +
        '                                <i class="glyphicon glyphicon-minus"></i>\n' +
        '                            </button>\n' +
        '                        </td>';
    new_line.id = 'article-'+new_line_id;
    new_line.appendAfter(document.getElementById('article-'+last_line_id));

}

function removeNewGoodsline(line_number)
{
    var element = document.getElementById('article-'+line_number);
    element.parentNode.removeChild(element);
}
