<?php

/**
 * Fired when the plugin is uninstalled.
 *
 * When populating this file, consider the following flow
 * of control:
 *
 * - This method should be static
 * - Check if the $_REQUEST content actually is the plugin name
 * - Run an admin referrer check to make sure it goes through authentication
 * - Verify the output of $_GET makes sense
 * - Repeat with other user roles. Best directly by using the links/query string parameters.
 * - Repeat things for multisite. Once for a single site in the network, once sitewide.
 *
 * @link       https://www.consignor.com/
 * @since      1.0.0
 *
 * @package    Wp_Cnsg
 */

// If uninstall not called from WordPress, then exit.
if ( ! defined( 'WP_UNINSTALL_PLUGIN' ) ) {
	exit;
}
//exit if not from plugin
if($_REQUEST['plugin'] != 'wp-cnsg/wp-cnsg.php')
{
	exit;
}

//exit if not admin
if( !is_admin() )
{
	// Throw an error in the WordPress admin console.
    $error_message = __( 'Plugin must be deleted by an user with administrator rights!', 'wp-cnsg' );
    die( wp_kses_post( $error_message ) );
}

wp_cnsg_deleteDB();

function wp_cnsg_deleteDB()
{
	global $wpdb;
	$table_name = $wpdb->prefix.'woocommerce_consignor_user';
	$query = $wpdb->prepare( "SHOW TABLES LIKE %s", $wpdb->esc_like( $table_name ) );

	if ( ! function_exists( 'is_plugin_active_for_network' ) )
	{
	    include_once( ABSPATH . '/wp-admin/includes/plugin.php' );
	}

	$sql = "DROP TABLE IF EXISTS $table_name";
    $wpdb->query($sql);
}