<?php

/**
 * Define the internationalization functionality
 *
 * Loads and defines the internationalization files for this plugin
 * so that it is ready for translation.
 *
 * @link       https://www.consignor.com/
 * @since      1.0.0
 *
 * @package    Wp_Cnsg
 * @subpackage Wp_Cnsg/includes
 */

/**
 * Define the internationalization functionality.
 *
 * Loads and defines the internationalization files for this plugin
 * so that it is ready for translation.
 *
 * @since      1.0.0
 * @package    Wp_Cnsg
 * @subpackage Wp_Cnsg/includes
 * @author     Consignor <integrations@consignor.com>
 */

// define('CONSIGNOR_URL','https://integration.consignor.com/woocommerce/');
define('CONSIGNOR_URL','https://integration.consignor.com/woocommerce/');

class Wp_Cnsg_i18n
{


	/**
	 * Load the plugin text domain for translation.
	 *
	 * @since    1.0.0
	 */
	public function load_plugin_textdomain() {

		load_plugin_textdomain(
			'wp-cnsg',
			false,
			dirname( dirname( plugin_basename( __FILE__ ) ) ) . '/languages/'
		);

	}



}
