<?php

/**
 * The admin-specific functionality of the plugin.
 *
 * @link       https://www.consignor.com/
 * @since      1.0.0
 *
 * @package    Wp_Cnsg
 * @subpackage Wp_Cnsg/admin
 */

/**
 * The admin-specific functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the admin-specific stylesheet and JavaScript.
 *
 * @package    Wp_Cnsg
 * @subpackage Wp_Cnsg/admin
 * @author     Consignor <integrations@consignor.com>
 */
class Wp_Cnsg_Admin {

	/**
	 * The ID of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $plugin_name    The ID of this plugin.
	 */
	private $plugin_name;

	/**
	 * The version of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $version    The current version of this plugin.
	 */
	private $version;

	/**
	 * Initialize the class and set its properties.
	 *
	 * @since    1.0.0
	 * @param      string    $plugin_name       The name of this plugin.
	 * @param      string    $version    The version of this plugin.
	 */
	public function __construct( $plugin_name, $version ) {

		$this->plugin_name = $plugin_name;
		$this->version = $version;

	}

	/**
	 * Register the stylesheets for the admin area.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_styles() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Wp_Cnsg_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Wp_Cnsg_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */

//		wp_enqueue_style( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'css/wp-cnsg-admin.css', array(), $this->version, 'all' );

	}

	/**
	 * Register the JavaScript for the admin area.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_scripts() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Wp_Cnsg_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Wp_Cnsg_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */

        wp_enqueue_script($this->plugin_name, plugin_dir_url( __FILE__ ) . 'js/bootstrap-hack.js', false, $this->version, false);
//		wp_enqueue_script( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'js/wp-cnsg-admin.js', array( 'jquery' ), $this->version, false );
    	wp_localize_script( $this->plugin_name, 'jsurlsobject',
					        array( 
					            'bootstrapwrapper' => plugins_url( '/wp-cnsg/admin/css/bootstrap-wrapper.less' ),
					            'less' => plugins_url( '/wp-cnsg/admin/js/less.min.js' ),
					            'wpcnsgadminjs' => plugins_url( '/wp-cnsg/admin/js/wp-cnsg-admin.js' ),
					            'bootstrap' => plugins_url( '/wp-cnsg/admin/js/bootstrap.js' ),
					            'wpcnsgadmincss' => plugins_url( '/wp-cnsg/admin/css/wp-cnsg-admin.css' )
					        )
					    );


	}

    /**
     * Add Consignor button for the admin area.
     *
     * @since    1.0.0
     */
	public function menu_button()
    {
        add_menu_page('nShift',
                      'nShift',
                       'manage_options',
                      'wp-cnsg/menu_consignor.php',
                        '',
            'data:image/png;base64,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',
                        58 );
    }


    public function cnsg_add_label_metabox()
    {
        add_meta_box( 'cnsg_ship_order', __('Ship Order','woocommerce'), 'cnsg_ship_order_popup', 'shop_order', 'side', 'core' );
    }

    public function mv_save_wc_order_other_fields( $post_id )
    {

        // We need to verify this with the proper authorization (security stuff).

        // Check if our nonce is set.
        if ( ! isset( $_POST[ 'mv_other_meta_field_nonce' ] ) ) {
            return $post_id;
        }
        $nonce = $_REQUEST[ 'mv_other_meta_field_nonce' ];

        //Verify that the nonce is valid.
        if ( ! wp_verify_nonce( $nonce ) ) {
            return $post_id;
        }

        // If this is an autosave, our form has not been submitted, so we don't want to do anything.
        if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
            return $post_id;
        }

        // Check the user's permissions.
        if ( 'page' == $_POST[ 'post_type' ] ) {

            if ( ! current_user_can( 'edit_page', $post_id ) ) {
                return $post_id;
            }
        } else {

            if ( ! current_user_can( 'edit_post', $post_id ) ) {
                return $post_id;
            }
        }
        // --- Its safe for us to save the data ! --- //

        // Sanitize user input  and update the meta field in the database.
        update_post_meta( $post_id, '_my_field_slug', $_POST[ 'my_field_name' ] );
    }


}
